<!DOCTYPE html>
<html>
<head>
    <title>Payment Success</title>
</head>
<body>
    <h1>New Booking </h1>
    
    <table class="table table-borderless">
        <tbody>
            <tr>
                <th>User</th>
                <td><?php echo e($booking->user->email); ?></td>
            </tr>
            <tr>
                <th>Car Model</th>
                <td><?php echo e($booking->car->name); ?></td>
            </tr>
            <tr>
                <th>Fuel type</th>
                <td><?php echo e($booking->car->fuel_type); ?></td>

            </tr>
            <tr>
                <th>Book_date</th>
                <td><?php echo e($booking->formatted_book_date); ?></td>
            </tr>

            <tr>
                <th>Return_date</th>
                <td><?php echo e($booking->formatted_return_date); ?></td>
            </tr>
            <tr>
                <th>Booking Duration</th>
                <td><?php echo e($booking->duration_in_days); ?> day's</td>
            </tr>
            <tr>
                <th>Price per day</th>
                <td>$<?php echo e($booking->car->price); ?></td>

            </tr>
            <tr>
                <th> <?php echo e($booking->duration_in_days); ?> day's Total Price</th>
                <td>$<?php echo e($booking->duration_in_days * $booking->car->price); ?></td>
            </tr>

            <tr>
                <th>Booking status</th>
                <td>
                    <?php if($booking->book_status === 'pending'): ?>
                        <strong
                            class="bg-warning p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                    <?php elseif($booking->book_status === 'approved'): ?>
                        <strong
                            class=" bg-success p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                    <?php elseif($booking->book_status === 'rejected'): ?>
                        <strong
                            class="bg-danger p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                    <?php else: ?>
                        <strong
                            class="bg-muted"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th>Payment status</th>

                <td>
                    <td>
                        <?php if($booking->payment->status === 'PAYER_ACTION_REQUIRED'): ?>
                            <strong class="text-light bg-warning p-1">
                                <?php echo e($booking->payment->status); ?>

                                
                            </strong>
                        <?php elseif($booking->payment->status === 'APPROVED'): ?>
                            <strong class="text-light bg-primary p-1">
                                <?php echo e($booking->payment->status); ?>

                                
                            </strong>
                        <?php elseif($booking->payment->status === 'COMPLETED'): ?>
                            <strong class="text-light bg-success p-1">
                                <?php echo e($booking->payment->status); ?>

                                PAID
                            </strong>
                        <?php else: ?>
                            <strong class="text-light bg-success p-1">
                                <?php echo e($booking->payment->status); ?>

                                ...
                            </strong>
                        <?php endif; ?>

                    </td>
                </td>

                </td>
            </tr>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH G:\xampp\htdocs\2024\07\carproject\resources\views/mails/booking_success.blade.php ENDPATH**/ ?>