<?php $__env->startSection('content'); ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h5 class="mb-0">Customer Details</h5>

                
            </div>
            <?php
                $user = Auth::user();
            ?>
            <div class="table-responsive mt-3">
                <table class="table align-middle">
                    <thead class="table-secondary">
                        <tr>
                            <th>User Name</th>
                            <th>Car Name</th>
                            <th>Book Place</th>
                            <th>Destination</th>
                            <th>Book Date</th>
                            <th>Return Date</th>
                            <th>Days Duration </th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($booking->user->name); ?></td>
                                <td><div class="d-flex align-items-center gap-3">
                                    <div class="product-box border">
                                        <img src="<?php echo e(asset($booking->car->image)); ?>" alt="">
                                    </div>
                                    <div class="product-info">
                                        <h6 class="product-name mb-1"><?php echo e($booking->car->name); ?></h6>
                                    </div>
                                </div></td>
                                <td><?php echo e($booking->book_place); ?></td>
                                <td><?php echo e($booking->destination); ?></td>
                                <td><?php echo e($booking->formatted_book_date); ?></td>
                                <td><?php echo e($booking->formatted_return_date); ?></td>
                                <td><?php echo e($booking->duration_in_days); ?> day's</td>
                                
                                <td>
                                    <?php if($booking->book_status === 'pending'): ?>
                                        <strong class="bg-warning p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php elseif($booking->book_status === 'approved'): ?>
                                        <strong class=" bg-success p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php elseif($booking->book_status === 'rejected'): ?>
                                        <strong class="bg-danger p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php else: ?>
                                        <strong class="bg-muted"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php endif; ?>
                                </td>
                                
                                <td>
                                    <div class="table-actions d-flex align-items-center gap-3 fs-6">


                                        
                                        <a href="<?php echo e(route('rent.edit', $booking->id)); ?>" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" aria-label="Edit">
                                            <div
                                                class="d-flex align-items-center px-2 cursor-pointer rounded  btn-outline-warning font-30">
                                                <i class=" fadeIn animated bx bx-edit"></i>
                                            </div>
                                        </a>


                                        
                                        <form action="<?php echo e(route('rent.destroy', $booking->id)); ?>" method="POST"
                                            style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn   btn-outline-light  "
                                                onclick="return confirm('Are you sure you want to delete this user?');">
                                                <div
                                                    class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                                    <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                                </div>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('my.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH G:\xampp\htdocs\2024\07\carproject\resources\views/my/admin/booking/index.blade.php ENDPATH**/ ?>