<?php $__env->startSection('content'); ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    
    <div class="card  ">
        <div class="  card-header bg-transparent border-success">
            <div class="row">
                <div class="col-sm order-2 order-sm-1">
                    <div class="d-flex align-items-start mt-3 mt-sm-0">
                        <div class="flex-shrink-0 rounded-full">
                            <div class="avatar-xl me-3">
                                <img src="https://hraproject.com/users/1708500372_admin2.jpg" alt="Profile Pic" width='100'
                                    class="img-thumbnail rounded-circle d-block">
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <table class="table table-borderless">
                                <tbody>

                                    <tr>
                                        <th>User Email : <?php echo e($booking->user->email); ?></th>
                                    </tr>
                                    <tr>
                                        <th>User Phone Number :<?php echo e($booking->user->phone_number); ?></th>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>


        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <table class="table table-borderless">
                        <tbody>
                            <tr>
                                <th>Car Model</th>
                                <td><?php echo e($booking->car->name); ?></td>
                            </tr>
                            <tr>
                                <th>Fuel type</th>
                                <td><?php echo e($booking->car->fuel_type); ?></td>

                            </tr>

                            <tr>
                                <th>Price per day</th>
                                <td>$<?php echo e($booking->car->price); ?></td>

                            </tr>

                            <tr>
                                <th>Book_date</th>
                                <td><?php echo e($booking->formatted_book_date); ?></td>
                            </tr>

                            <tr>
                                <th>Return_date</th>
                                <td><?php echo e($booking->formatted_return_date); ?></td>
                            </tr>
                            <tr>
                                <th>Booking Duration</th>
                                <td><?php echo e($booking->duration_in_days); ?> day's</td>
                            </tr>

                            <tr>
                                <th>Booking status</th>
                                <td>
                                    <?php if($booking->book_status === 'pending'): ?>
                                        <strong class="bg-warning p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php elseif($booking->book_status === 'approved'): ?>
                                        <strong class=" bg-success p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php elseif($booking->book_status === 'rejected'): ?>
                                        <strong class="bg-danger p-1"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php else: ?>
                                        <strong class="bg-muted"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php endif; ?>
                                </td>
                            </tr>

                            <tr>
                                <th>Payment Status</th>
                                <td>
                                    <?php if($booking->payment->status === 'APPROVED'): ?>
                                        <strong class="bg-warning p-1"><?php echo e(ucfirst($booking->payment->status)); ?></strong>
                                    <?php elseif($booking->payment->status === 'COMPLETED'): ?>
                                        <strong class=" bg-success p-1">Paid</strong>
                                    <?php elseif($booking->payment->status === 'PAYER_ACTION_REQUIRED'): ?>
                                        <strong class="bg-danger p-1"><?php echo e(ucfirst($booking->payment->status)); ?></strong>
                                    <?php else: ?>
                                        <strong class="bg-muted"><?php echo e(ucfirst($booking->book_status)); ?></strong>
                                    <?php endif; ?>
                                </td>
                                
                            </tr>
                        </tbody>
                    </table>

                         
                    
                    <form action="<?php echo e(route('rent.update', $booking->id)); ?>" method="POST" style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <input type="hidden" name="book_status" value="approved">
                        <button type="submit" class="btn   btn-outline-light  "
                            onclick="return confirm('Are you sure you want to Approve this car?');">
                            <div
                                class="d-flex align-items-center theme-icons shadow-sm p-2 cursor-pointer rounded btn-outline-success">
                                <div class="font-22"> <i class="fadeIn animated bx bx-check-double"></i>
                                </div>
                                <div class="ms-2">Approve</div>
                            </div>
                        </button>
                    </form>

                    
                    <form action="<?php echo e(route('rent.update', $booking->id)); ?>" method="POST" style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <input type="hidden" name="book_status" value="rejected">

                        <button type="submit" class="btn   btn-outline-light  "
                            onclick="return confirm('Are you sure you want to Reject this car?');">
                            <div
                                class="d-flex align-items-center theme-icons shadow-sm p-2 cursor-pointer rounded btn-outline-danger">
                                <div class="font-22"> <i class="fadeIn animated bx bx-x-circle"></i>
                                </div>
                                <div class="ms-2">Reject</div>
                            </div>
                        </button>
                    </form>
                </div>

                <div class="col-lg-6">
                    <img class="img-thumbnail" alt="200x200" width="400" src="<?php echo e(asset($booking->car->image)); ?>"
                        data-holder-rendered="true">
                </div>
            </div>

        </div>

        <!-- end card body -->
    </div>


    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('my.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH G:\xampp\htdocs\2024\07\carproject\resources\views/my/admin/booking/edit.blade.php ENDPATH**/ ?>