<?php

use App\Http\Controllers\Admin\CarController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\FeedbackController;
use App\Http\Controllers\FrontEnd\PaymentController;
use App\Http\Controllers\Page\BookController;
use App\Http\Controllers\Page\CarController as PageCarController;
use App\Http\Controllers\ProfileController;
use App\Models\Booking;
use App\Models\Car;
use App\Models\Feedback;
use Illuminate\Support\Facades\Route;

// added gpt
Route::get('/dashboard', function () {
    if (auth()->user()->role == 'admin') {
        return redirect()->route('admin.dashboard');
    } else {
        return redirect()->route('dashboard');
    }
})->middleware('auth');

Route::group(['middleware' => ['auth', 'role:admin']], function () {
    // Route::get('/admin/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/dashboard',function () {
        return view('my.admin.dashboard');
    })->name('admin.dashboard');
    // Other admin routes
});

Route::group(['middleware' => ['auth', 'role:user']], function () {
    // Route::get('/user/dashboard', [UserController::class, 'index'])->name('user.dashboard');
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
});
// added

// guest
Route::get('/', function () {
    $cars = Car::all();
    return view('welcome', ['cars' => $cars]);
});

// auth user
Route::middleware('auth')->group(function () {
    Route::get('/car', [PageCarController::class, 'index'])->name('car');
    Route::get('/car/{id}/show', [PageCarController::class, 'show'])->name('single-car');
    Route::get('/booking', [BookController::class, 'index'])->name('booking');
    Route::resource('/feedback' , FeedbackController::class);
    Route::resource('/book' , BookingController::class);


    Route::get('/contact', function () {
        return view('my.authuser.contact');
    })->name('contact');

    Route::get('/faq', function () {
        return view('my.authuser.faq');
    })->name('faq');

    Route::get('/about', function () {
        return view('my.authuser.about');
    })->name('about');

    Route::get('/service', function () {
        return view('my.authuser.service');
    })->name('service');

    Route::get('/review', function () {
        $feedbacks = Feedback::all();
        // dd($cars);
        return view('my.authuser.review', ['feedbacks' => $feedbacks]);
    })->name('review');

    Route::get('/team', function () {
        return view('my.authuser.team');
    })->name('team');

    Route::get('/status/{id}', function ($id) {
        $bookings = Booking::where('user_id' , $id)->get();
        // dd($booking->name);
        return view('my.authuser.booking-status' , ['bookings' => $bookings]);
    })->name('status');

    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

});

// auth user profile
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});


// admin panel
Route::middleware('auth')->prefix('admin')->group(function () {
    Route::get('dashboard', function () {
        return view('my.admin.dashboard');
    })->name('admin.dashboard');

    Route::resource('car', CarController::class);
    Route::resource('user', UserController::class);
});

//paypal
Route::get('payment-status', array('as' => 'paywithpaypal', 'uses' => [PaypalController::class, 'payWithPaypal']));
Route::get('payment', [PaymentController::class, 'postPaymentWithpaypal']);
Route::get('success', [PaymentController::class, 'success'])->name('success');
Route::get('cancel', [PaymentController::class, 'cancel'])->name('cancel');





require __DIR__ . '/auth.php';



Route::get('/profile/reset-password/{id}' , [ProfileController::class , 'resetPassword']); //new added
Route::get('/profile/reset-password/{id}/reset' , [ProfileController::class , 'newPassword']); //new added
Route::put('/profile/reset-password/{id}/update' , [ProfileController::class , 'savePassword']); //new added
Route::get('/cache', function () {
    Artisan::call('route:cache');
    $output = Artisan::output();
    return $output;
});
Route::get('/list', function () {
    Artisan::call('route:list');
    $output = Artisan::output();
    return $output;
});
Route::get('/fresh', function () {
    Artisan::call('migrate:fresh');
    $output = Artisan::output();
    return $output;
});
Route::get('/seed', function () {
    Artisan::call('db:seed');
    $output = Artisan::output();
    return $output;
});
