<x-app-layout>
  {{-- <!-- hero section start  -->
  <section id="hero" class=" position-relative overflow-hidden">
    <div class="pattern-overlay pattern-right position-absolute">
        <img src="{{ asset('assets/images/hero-pattern-right.png') }}" alt="pattern">
    </div>
    <div class="pattern-overlay pattern-left position-absolute">
        <img src="{{ asset('assets/images/hero-pattern-left.png') }}" alt="pattern">
    </div>
    <div class="container py-5 mt-5">
        <div class="row my-5">
            <h2 class="mt-5">{{$car->name}}</h2>

            <div class="d-flex ">
                <p class="fs-5 ">Lectus adipiscing est auctor</p>
                <p style="color: #94CA21">&nbsp; | &nbsp;</p>
                <p class=" fs-5 fw-semibold"> For Rent </p>
                <p style="color: #94CA21">&nbsp; | &nbsp;</p>
                <p class=" fs-5 fw-semibold"> Price : $9000 / day</p>
            </div>
        </div>
    </div>
</section> --}}

<div class="post-wrap  no-padding-bottom">
    <div class="container">

        <div class="row my-5 g-5">
            <main class="post-grid col-md-9">
                <div class="row">
                    <article class="property">

                        <div class="row flex-column">
                            <div class="col-md-12">
                                <!-- product-large-slider -->
                                <div class="swiper product-large-slider">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <img  src="{{ asset($car->image) }}" alt="{{ $car->name }}" class="img-fluid">
                                        </div>
                                    </div>
                                </div>
                                <!-- / product-large-slider -->
                            </div>
                            {{-- <div class="col-md-12 mt-2">
                                <!-- product-thumbnail-slider -->
                                <div thumbsSlider="" class="swiper product-thumbnail-slider">
                                    <div class="swiper-wrapper">
                                        <div class="swiper-slide">
                                            <img src="{{ asset('assets/images/blog8.jpg') }}" alt="image"
                                                class="thumb-image img-fluid">
                                        </div>
                                        <div class="swiper-slide">
                                            <img src="{{ asset('assets/images/blog5.jpg') }}" alt="image"
                                                class="thumb-image img-fluid">
                                        </div>
                                        <div class="swiper-slide">
                                            <img src="{{ asset('assets/images/blog4.jpg') }}" alt="image"
                                                class="thumb-image img-fluid">
                                        </div>
                                        <div class="swiper-slide">
                                            <img src="{{ asset('assets/images/blog9.jpg') }}" alt="image"
                                                class="thumb-image img-fluid">
                                        </div>
                                        <div class="swiper-slide">
                                            <img src="{{ asset('assets/images/blog1.jpg') }}" alt="image"
                                                class="thumb-image img-fluid">
                                        </div>

                                    </div>
                                </div>
                                <!-- / product-thumbnail-slider -->
                            </div> --}}

                        </div>

                        <div class="post-content py-5">

                            <div class="overview my-5">
                                <h3 class="fs-2 mb-4">Vehicle Overview</h3>

                                <div class="row row-cols-1 row-cols-sm-2 row-cols-md-4 g-4 mt-1">
                                    <div class="col d-flex align-items-start">
                                        <iconify-icon icon="fa-solid:car"
                                            class="property-icon border rounded-2 p-3"></iconify-icon>
                                        <div class="ms-4 mt-2">
                                            <h6 class="fw-bold mb-0 mt-1 fs-6 text-body-emphasis">Body</h6>
                                            <p>{{$car->name}}</p>
                                        </div>
                                    </div>

                                    <div class="col d-flex align-items-start">
                                        <iconify-icon icon="bi:fuel-pump"
                                            class="property-icon border rounded-2 p-3"></iconify-icon>
                                        <div class="ms-4 mt-2">
                                            <h6 class="fw-bold mb-0 mt-1 fs-6 text-body-emphasis">Fuel Type</h6>
                                            <p>{{Str::ucfirst($car->fuel_type)}}</p>
                                        </div>
                                    </div>


                                    <div class="col d-flex align-items-start">
                                        <iconify-icon icon="icon-park:oceanengine"
                                            class="property-icon border rounded-2 p-3"></iconify-icon>
                                        <div class="ms-4 mt-2">
                                            <h6 class="fw-bold mb-0 mt-1 fs-6 text-body-emphasis">Capacity
                                            </h6>
                                            <p>{{$car->capacity}}</p>
                                        </div>
                                    </div>


                                </div>

                            </div>
                            <hr>
                            <div class="price my-5">
                                <h3 class=" fs-2 mb-4">Price Details</h3>
                                <p> <span class="fw-bold  ">Rent/Day :</span> {{$car->price}}</p>
                                <p> <span class="fw-bold  ">Rent/Month :</span> 30,000 (negotiable)</p>
                                {{-- <p> <span class="fw-bold  ">Service Charge :</span> 500 (service providing)</p>
                                <p> <span class="fw-bold  ">Extra Service :</span> As per Service taken</p>
                                <p> <span class="fw-bold  ">Security Deposit :</span> 1500 </p> --}}

                            </div>
                            {{-- <hr>
                            <div class="details my-5">
                                <h3 class=" fs-2 mb-4">Vehicle Details</h3>
                               <p></p>
                            </div> --}}

                        </div>
                    </article>

                </div>
            </main>
            <aside class="col-md-3">
                <div class=" ">
                    <form id="form"  action="{{ route('booking.create') }}"
                        method="POST">
                        @csrf
                        <h2 class=" fs-2 text-uppercase text-black my-3">Book Now</h2>
                        {{-- <div class="form-input col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Full
                                Name</label>
                            <input type="text" name="email" placeholder="Write Your Name Here"
                                class="form-control ps-3">

                        </div>
                        <div class="form-input col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Email
                                Address</label>
                            <input type="text" name="email" placeholder="Write Your Email Here"
                                class="form-control ps-3">
                        </div>
                        <div class="col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Phone
                                Number</label>
                            <input type="text" name="email" placeholder="Phone Number"
                                class="form-control ps-3">
                        </div> --}}

                        <input type="hidden" name="user_id"  value="{{Auth::user()->id}}">
                        <input type="hidden" name="car_id"  value="{{$car->id}}">
                        <input type="hidden" name="book_status"  value="pending">

                        <div class="form-input col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Book Place</label>
                            <input type="text" name="book_place" placeholder="Write Your Name Here"
                                class="form-control ps-3" value="{{ old('book_place') }}">
                                @error('book_place')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror

                        </div>
                        <div class="form-input col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Destination</label>
                            <input type="text" name="destination" placeholder="Write Your Destination Here"
                                class="form-control ps-3" value="{{ old('destination') }}">
                                @error('destination')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                        </div>

                        <div class="col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Pick-up
                                Date</label>
                            <div class="input-group date" id="datepicker">

                                <input type="date" id="start" name="book_date" min="{{date('Y-m-d')}}"
                                    max="{{date('Y-m-d', strtotime('+2 months'))}}" class="form-control ps-3" value="{{ old('book_date') }}">
                                    @error('book_date')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                            </div>
                        </div>

                        <div class="col-lg-12 my-4">
                            <label for="exampleInputEmail1"
                                class="form-label fs-6 text-uppercase fw-bold text-black">Returning
                                date</label>
                            <div class="input-group date" id="datepicker">
                                <input type="date" id="start" name="return_date"min="{{date('Y-m-d')}}"
                                max="{{date('Y-m-d', strtotime('+3 months'))}}" class="form-control ps-3"
                                    value="{{ old('return_date') }}">
                                @error('return_date')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>


                        <div class="d-grid mb-3">
                            <button class="btn btn-primary btn-lg text-uppercase btn-rounded-none">Book</button>
                        </div>
                    </form>
                </div>
            </aside>
        </div>
    </div>
</div>



</x-app-layout>

