<x-app-layout>

    @if (count($bookings) == 0)
        <h1 class="text-center bg-primary p-5">0 booking</h1>
    @else
        @foreach ($bookings as $booking)
            <section class="contact-us-wrap py-5">
                <div class="container border ">
                    <div class="row ">
                        <div class="card  ">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <table class="table table-borderless">
                                            <tbody>
                                                <tr>
                                                    <th>Car Model</th>
                                                    <td>{{ $booking->car->name }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Fuel type</th>
                                                    <td>{{ $booking->car->fuel_type }}</td>

                                                </tr>
                                                <tr>
                                                    <th>Book_date</th>
                                                    <td>{{ $booking->formatted_book_date }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Return_date</th>
                                                    <td>{{ $booking->formatted_return_date }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Booking Duration</th>
                                                    <td>{{ $booking->duration_in_days }} day's</td>
                                                </tr>
                                                <tr>
                                                    <th>Price per day</th>
                                                    <td>${{ $booking->car->price }}</td>

                                                </tr>
                                                <tr>
                                                    <th> {{ $booking->duration_in_days }} day's Total Price</th>
                                                    <td>${{ $booking->duration_in_days * $booking->car->price }}</td>
                                                </tr>

                                                <tr>
                                                    <th>Booking status</th>
                                                    <td>
                                                        @if ($booking->book_status === 'pending')
                                                            <strong
                                                                class="bg-warning p-1">{{ ucfirst($booking->book_status) }}</strong>
                                                        @elseif($booking->book_status === 'approved')
                                                            <strong
                                                                class=" bg-success p-1">{{ ucfirst($booking->book_status) }}</strong>
                                                        @elseif($booking->book_status === 'rejected')
                                                            <strong
                                                                class="bg-danger p-1">{{ ucfirst($booking->book_status) }}</strong>
                                                        @else
                                                            <strong
                                                                class="bg-muted">{{ ucfirst($booking->book_status) }}</strong>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Payment status</th>

                                                    <td>
                                                        @if ($booking->payment->status === 'PAYER_ACTION_REQUIRED')
                                                            <strong class="text-light bg-warning p-1">
                                                                {{ $booking->payment->status }}
                                                                {{-- PAID --}}
                                                            </strong>
                                                        @elseif($booking->payment->status === 'APPROVED')
                                                            <strong class="text-light bg-primary p-1">
                                                                {{ $booking->payment->status }}
                                                                {{-- PAID --}}
                                                            </strong>
                                                        @elseif($booking->payment->status === 'COMPLETED')
                                                            <strong class="text-light bg-success p-1">
                                                                {{-- {{ $booking->payment->status }} --}}
                                                                PAID
                                                            </strong>
                                                        @else
                                                            <strong class="text-light bg-success p-1">
                                                                {{ $booking->payment->status }}
                                                                ...
                                                            </strong>
                                                        @endif

                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-lg-6">
                                        <img class="img-thumbnail" alt="200x200" width="400"
                                            src="{{ asset($booking->car->image) }}" data-holder-rendered="true">
                                    </div>
                                </div>

                            </div>

                            <!-- end card body -->
                        </div>
                    </div>
                </div>
            </section>
        @endforeach
    @endif







</x-app-layout>
