@extends('my.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('user.update', $user->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-12 col-lg-12">
                <div class="card shadow-sm border-0">
                    <div class="card-body">

                        <div class="d-flex justify-content-between">
                            <h5 class="mb-0">My Account</h5>
                            <a href="{{ route('user.create') }}" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                aria-label="Views">
                                <div
                                    class="d-flex align-items-center theme-icons shadow-sm  cursor-pointer rounded btn btn-outline-primary">
                                    <div class="font-16"> <i class="fadeIn animated bx bx-plus"></i>
                                    </div>
                                    <div class="ms-2">Create</div>
                                </div>
                            </a>
                        </div>
                        <hr>
                        <div class="card shadow-none border">
                            <div class="card-header">
                                <h6 class="mb-0">USER INFORMATION</h6>
                            </div>
                            <div class="card-body row g-3">
                                {{-- <form class="row g-3" action="{{ route('user.update', $user->id) }}" method="POST">
                                @csrf
                                @method('PUT') --}}
                                <div class="col-12 col-lg-6 ">
                                    <label class="form-label">Username</label>
                                    <input type="text" name="name" class="form-control" value="{{ $user->name }}">
                                    @error('name')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                <div class="col-12 col-lg-6">
                                    <label class="form-label">Email address</label>
                                    <input type="text" name="email" class="form-control" value="{{ $user->email }}">
                                    @error('email')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>

                                {{-- </form> --}}
                            </div>
                        </div>
                        <div class="card shadow-none border">
                            <div class="card-header">
                                <h6 class="mb-0">Role </h6>
                            </div>
                            <div class="card-body">
                                {{-- <form action="{{ route('user.update', $user->id) }}" method="POST">
                                @csrf
                                @method('PUT') --}}
                                {{-- Role --}}
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label class="form-label">Select2 Multiple Role</label>

                                        <select name="roles[]" class="multiple-select" data-placeholder="Choose anything"
                                            multiple="multiple">
                                            @foreach ($roles as $role)
                                                <option value="{{ $role->name }}"
                                                    @if (in_array($role->id, $userRoles)) selected @endif>
                                                    {{ $role->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @error('roles')
                                        <p class="text-danger">{{ $message }}</p>
                                    @enderror
                                </div>
                                {{-- </form> --}}
                            </div>
                        </div>
                        <div class="text-start">
                            <button type="submit" class="btn btn-primary px-4">Save Changes</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
