@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('car.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        {{-- <div class="row"> --}}
        {{-- <div class="col-lg-8 mx-auto"> --}}
        <div class="card">
            <div class="card-header py-3 bg-transparent">
                <h5 class="mb-0">Add New Car</h5>
            </div>
            <div class="card-body">
                <div class="border p-3 rounded">
                    <form class="row g-3">
                        <div class="col-12 pb-2">
                            <label class="form-label">Car title</label>
                            <input type="text" class="form-control" name='name' placeholder="Car title"
                                value="{{ old('name') }}">
                            @error('name')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="row">
                            {{-- price --}}
                            <div class="col-12  col-md-6 pb-2">
                                <label class="form-label">Car price</label>
                                <input type="number" class="form-control" name='price' placeholder="Car price"
                                    value="{{ old('price') }}">
                                @error('price')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- capacity --}}
                            <div class="col-12  col-md-6 pb-2">
                                <label class="form-label">Car Capacity</label>
                                <input type="number" class="form-control" name='capacity' placeholder="Car Capacity"
                                    value="{{ old('capacity') }}">
                                @error('capacity')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        {{-- description --}}
                        {{-- <div class="col-12 pb-2">
                            <label class="form-label">Full description</label>
                            <textarea class="form-control" placeholder="Full description" rows="4" cols="4"></textarea>
                        </div> --}}

                        <div class="row">

                            {{-- Fuel type --}}
                            <div class="col-12 col-md-6 pb-2">
                                <label class="form-label">Fuel type</label>
                                <select name="fuel_type" class="form-select">
                                    <option value="diesel"> Diesel </option>
                                    <option value="petrol"> Petrol </option>
                                    <option value="oil"> Oil </option>
                                </select>
                            </div>

                            {{-- Status --}}
                            <div class="col-12 col-md-6 pb-2">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="yes"> Available </option>
                                    <option value="no"> Rented </option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            {{-- Images --}}
                            <div class="col-12 col-md-6 pb-2">
                                <label class="form-label">Images</label>
                                <input class="form-control" name="image" type="file">
                                @error('image')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                            </div>
                        </div>

                        <div class="col-12 pb-2">
                            <button class="btn btn-primary px-4">Submit Item</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
        </div>
        </div>
    </form>
@endsection
