@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h5 class="mb-0">Faq's</h5>
            </div>

            <div class="table-responsive mt-3">
                <table class="table align-middle">
                    <thead class="table-secondary">
                        <tr>
                            <th>User Name</th>
                            <th>Question</th>

                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($faqs as $faq)
                            <tr>
                                <td>{{$faq->user->name}}</td>
                                <td>{{$faq->subject}}</td>

                                <td>
                                    <div class="table-actions d-flex align-items-center gap-3 fs-6">


                                        {{-- edit --}}
                                        <a href="{{ route('faqs.edit', $faq->id) }}" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" aria-label="Edit">
                                            <div
                                                class="d-flex align-items-center px-2 cursor-pointer rounded  btn-outline-warning font-30">
                                                <i class=" fadeIn animated bx bx-edit"></i>
                                            </div>
                                        </a>


                                        {{-- delete --}}
                                        <form action="{{ route('rent.destroy', $faq->id) }}" method="POST"
                                            style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn   btn-outline-light  "
                                                onclick="return confirm('Are you sure you want to delete this user?');">
                                                <div
                                                    class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                                    <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                                </div>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
