@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif


    <div class="card  ">
        <div class="card-header py-3 bg-transparent">
            <h5 class="mb-0">Faq Answer</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-12">

                    <div class="inquiry-item col-md-12">
                        <h2 class="fs-3 text-uppercase mb-4 text-danger">{{ $faq->subject }}</h2>
                        <form id="form" class="form-group flex-wrap" action="{{ route('faqs.update', $faq->id) }}"
                            method="POST">
                            @csrf
                            @method('PUT')
                            <div class="col-lg-12 mb-3">
                                <textarea name="message" placeholder="Write Your Answer Here" class="form-control ps-3" rows="8"
                                    >{{ $faq->comment }}</textarea>

                                @error('message')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="col-12  pb-2">
                                <label class="form-label">Diplayy</label>
                                <select name="display" class="form-select">

                                    <option value="1">Show</option>
                                    <option value="0"> Hide </option>
                                </select>
                            </div>
                            <div class="d-grid">
                                <button class="btn btn-primary btn-lg text-uppercase btn-rounded-none">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>


            </div>

        </div>
    </div>
@endsection
