@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('car.update' , $car->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        {{-- <div class="row"> --}}
        {{-- <div class="col-lg-8 mx-auto"> --}}
        <div class="card">
            <div class="card-header py-3 bg-transparent">
                <h5 class="mb-0">Edit Car</h5>
            </div>
            <div class="card-body">
                <div class="border p-3 rounded">
                    <form class="row g-3">
                        <div class="col-12 pb-2">
                            <label class="form-label">Car title</label>
                            <input type="text" class="form-control" name='name' placeholder="Car title"
                                value="{{ $car->name }}">
                            @error('name')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="row">
                            {{-- price --}}
                            <div class="col-12  col-md-6 pb-2">
                                <label class="form-label">Car price</label>
                                <input type="number" class="form-control" name='price' placeholder="Car price"
                                    value="{{ $car->price }}">
                                @error('price')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- capacity --}}
                            <div class="col-12  col-md-6 pb-2">
                                <label class="form-label">Car Capacity</label>
                                <input type="number" class="form-control" name='capacity' placeholder="Car Capacity"
                                    value="{{ $car->capacity }}">
                                @error('capacity')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        {{-- description --}}
                        {{-- <div class="col-12 pb-2">
                            <label class="form-label">Full description</label>
                            <textarea class="form-control" placeholder="Full description" rows="4" cols="4"></textarea>
                        </div> --}}

                        <div class="row">

                            {{-- Fuel type --}}
                            <div class="col-12 col-md-6 pb-2">
                                <label class="form-label">Fuel type</label>
                                <select name="fuel_type" class="form-select">

                                    <option value="diesel"  @if ($car->fuel_type == 'diesel')  selected @endif> Diesel </option>
                                    <option value="petrol" @if ($car->fuel_type == 'petrol')  selected @endif > Petrol </option>
                                    <option value="oil"  @if ($car->fuel_type == 'oil')  selected @endif> Oil </option>
                                </select>
                            </div>

                            {{-- Status --}}
                            <div class="col-12 col-md-6 pb-2">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    @if ($car->status== 'yes')
                                    <option value="yes" selected> Available </option>
                                    <option value="no"> Rented </option>
                                    @else
                                    <option value="yes"> Available </option>
                                    <option value="no" selected> Rented </option>
                                    @endif
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            {{-- Images --}}
                            <div class="col-12 col-md-6 pb-2">
                                <label class="form-label">Images</label>
                                <input class="form-control" name="image" type="file">
                                @error('image')
                                <p class="text-danger">{{ $message }}</p>
                            @enderror
                            </div>
                        </div>

                        <div class="col-12 pb-2">
                            <button class="btn btn-primary px-4">Update</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
        </div>
        </div>
    </form>
@endsection
