@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h5 class="mb-0">Customer Details</h5>

                {{-- <a href="{{ route('rent.create') }}" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Views">
                    <div
                        class="d-flex align-items-center theme-icons shadow-sm  cursor-pointer rounded btn btn-outline-primary">
                        <div class="font-16"> <i class="fadeIn animated bx bx-plus"></i>
                        </div>
                        <div class="ms-2">Create</div>
                    </div>
                </a> --}}
            </div>
            @php
                $user = Auth::user();
            @endphp
            <div class="table-responsive mt-3">
                <table class="table align-middle">
                    <thead class="table-secondary">
                        <tr>
                            <th>User Name</th>
                            <th>Car Name</th>
                            <th>Book Place</th>
                            <th>Destination</th>
                            <th>Book Date</th>
                            <th>Return Date</th>
                            <th>Days Duration </th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($bookings as $booking)
                            <tr>
                                <td>{{ $booking->user->name }}</td>
                                <td><div class="d-flex align-items-center gap-3">
                                    <div class="product-box border">
                                        <img src="{{ asset($booking->car->image) }}" alt="">
                                    </div>
                                    <div class="product-info">
                                        <h6 class="product-name mb-1">{{$booking->car->name}}</h6>
                                    </div>
                                </div></td>
                                <td>{{ $booking->book_place }}</td>
                                <td>{{ $booking->destination }}</td>
                                <td>{{ $booking->formatted_book_date }}</td>
                                <td>{{ $booking->formatted_return_date }}</td>
                                <td>{{ $booking->duration_in_days }} day's</td>
                                {{-- <td><strong class="bg-warning p-1 ">{{ ucfirst($booking->book_status) }}</strong></td> --}}
                                <td>
                                    @if ($booking->book_status === 'pending')
                                        <strong class="bg-warning p-1">{{ ucfirst($booking->book_status) }}</strong>
                                    @elseif($booking->book_status === 'approved')
                                        <strong class=" bg-success p-1">{{ ucfirst($booking->book_status) }}</strong>
                                    @elseif($booking->book_status === 'rejected')
                                        <strong class="bg-danger p-1">{{ ucfirst($booking->book_status) }}</strong>
                                    @else
                                        <strong class="bg-muted">{{ ucfirst($booking->book_status) }}</strong>
                                    @endif
                                </td>
                                {{-- view --}}
                                <td>
                                    <div class="table-actions d-flex align-items-center gap-3 fs-6">


                                        {{-- edit --}}
                                        <a href="{{ route('rent.edit', $booking->id) }}" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" aria-label="Edit">
                                            <div
                                                class="d-flex align-items-center px-2 cursor-pointer rounded  btn-outline-warning font-30">
                                                <i class=" fadeIn animated bx bx-edit"></i>
                                            </div>
                                        </a>


                                        {{-- delete --}}
                                        <form action="{{ route('rent.destroy', $booking->id) }}" method="POST"
                                            style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn   btn-outline-light  "
                                                onclick="return confirm('Are you sure you want to delete this user?');">
                                                <div
                                                    class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                                    <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                                </div>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
