@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    {{-- car --}}
    <div class="card  ">
        <div class="  card-header bg-transparent border-success">
            <div class="row">
                <div class="col-sm order-2 order-sm-1">
                    <div class="d-flex align-items-start mt-3 mt-sm-0">
                        <div class="flex-shrink-0 rounded-full">
                            <div class="avatar-xl me-3">
                                <img src="https://hraproject.com/users/1708500372_admin2.jpg" alt="Profile Pic" width='100'
                                    class="img-thumbnail rounded-circle d-block">
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <table class="table table-borderless">
                                <tbody>

                                    <tr>
                                        <th>User Email : {{ $booking->user->email }}</th>
                                    </tr>
                                    <tr>
                                        <th>User Phone Number :{{ $booking->user->phone_number }}</th>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>


        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <table class="table table-borderless">
                        <tbody>
                            <tr>
                                <th>Car Model</th>
                                <td>{{ $booking->car->name }}</td>
                            </tr>
                            <tr>
                                <th>Fuel type</th>
                                <td>{{ $booking->car->fuel_type }}</td>

                            </tr>

                            <tr>
                                <th>Price per day</th>
                                <td>${{ $booking->car->price }}</td>

                            </tr>

                            <tr>
                                <th>Book_date</th>
                                <td>{{ $booking->formatted_book_date }}</td>
                            </tr>

                            <tr>
                                <th>Return_date</th>
                                <td>{{ $booking->formatted_return_date }}</td>
                            </tr>
                            <tr>
                                <th>Booking Duration</th>
                                <td>{{ $booking->duration_in_days }} day's</td>
                            </tr>

                            <tr>
                                <th>Booking status</th>
                                <td>
                                    @if ($booking->book_status === 'pending')
                                        <strong class="bg-warning p-1">{{ ucfirst($booking->book_status) }}</strong>
                                    @elseif($booking->book_status === 'approved')
                                        <strong class=" bg-success p-1">{{ ucfirst($booking->book_status) }}</strong>
                                    @elseif($booking->book_status === 'rejected')
                                        <strong class="bg-danger p-1">{{ ucfirst($booking->book_status) }}</strong>
                                    @else
                                        <strong class="bg-muted">{{ ucfirst($booking->book_status) }}</strong>
                                    @endif
                                </td>
                            </tr>

                            <tr>
                                <th>Payment Status</th>
                                <td>
                                    @if ($booking->payment->status === 'APPROVED')
                                        <strong class="bg-warning p-1">{{ ucfirst($booking->payment->status) }}</strong>
                                    @elseif($booking->payment->status === 'COMPLETED')
                                        <strong class=" bg-success p-1">Paid</strong>
                                    @elseif($booking->payment->status === 'PAYER_ACTION_REQUIRED')
                                        <strong class="bg-danger p-1">{{ ucfirst($booking->payment->status) }}</strong>
                                    @else
                                        <strong class="bg-muted">{{ ucfirst($booking->book_status) }}</strong>
                                    @endif
                                </td>
                                {{-- <td>{{ $booking->payment->status }}</td> --}}
                            </tr>
                        </tbody>
                    </table>

                         {{-- approve
                         <form action="{{ route('book.update', $booking->id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="book_status" value="pending">
                            <button type="submit" class="btn   btn-outline-light  "
                                onclick="return confirm('Are you sure you want to Approve this car?');">
                                <div
                                    class="d-flex align-items-center theme-icons shadow-sm p-2 cursor-pointer rounded btn-outline-warning">
                                    <div class="font-22"> <i class="fadeIn animated bx bx-check"></i>
                                    </div>
                                    <div class="ms-2 ">Hold</div>
                                </div>
                            </button>
                        </form> --}}
                    {{-- approve --}}
                    <form action="{{ route('rent.update', $booking->id) }}" method="POST" style="display: inline;">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="book_status" value="approved">
                        <button type="submit" class="btn   btn-outline-light  "
                            onclick="return confirm('Are you sure you want to Approve this car?');">
                            <div
                                class="d-flex align-items-center theme-icons shadow-sm p-2 cursor-pointer rounded btn-outline-success">
                                <div class="font-22"> <i class="fadeIn animated bx bx-check-double"></i>
                                </div>
                                <div class="ms-2">Approve</div>
                            </div>
                        </button>
                    </form>

                    {{-- reject --}}
                    <form action="{{ route('rent.update', $booking->id) }}" method="POST" style="display: inline;">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="book_status" value="rejected">

                        <button type="submit" class="btn   btn-outline-light  "
                            onclick="return confirm('Are you sure you want to Reject this car?');">
                            <div
                                class="d-flex align-items-center theme-icons shadow-sm p-2 cursor-pointer rounded btn-outline-danger">
                                <div class="font-22"> <i class="fadeIn animated bx bx-x-circle"></i>
                                </div>
                                <div class="ms-2">Reject</div>
                            </div>
                        </button>
                    </form>
                </div>

                <div class="col-lg-6">
                    <img class="img-thumbnail" alt="200x200" width="400" src="{{ asset($booking->car->image) }}"
                        data-holder-rendered="true">
                </div>
            </div>

        </div>

        <!-- end card body -->
    </div>


    {{-- <div class="col-lg-6 ">

        <form action="{{ route('book.update', $booking->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="row">


                <div class="col-lg-6">
                    <div>
                        <div class="form-group mb-3">
                            <label for="first name" class="form-label">First name</label>
                            <input class="form-control" type="text" name="first_name"
                                id="first name" placeholder="insert first name here"
                                value="manager">
                        </div>
                    </div>
                </div>


                <div class="col-lg-6">
                    <div>
                        <div class="form-group mb-3">
                            <label for="sub-first name" class="form-label">Last name</label>
                            <input class="form-control" type="text" name="last_name"
                                id="sub-first name" placeholder="insert last name here"
                                value="Baloch">
                        </div>
                    </div>
                </div>

            </div>


            <div class="row">


                <div class="col-lg-6">
                    <div>
                        <div class="form-group mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input class="form-control" type="password" name="password"
                                id="password" placeholder="insert password here" value="">
                        </div>
                    </div>
                </div>



                <div class="col-lg-6">
                    <div>
                        <div class="form-group mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input class="form-control" type="email" name="email" id="email"
                                placeholder="insert email here" value="manager@gmail.com">
                        </div>
                    </div>
                </div>

            </div>


            <div class="row">


                <div class="col-lg-6">
                    <div>
                        <div class="form-group mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select name="status" id="status" class="form-select">
                                <option value="pending" selected="">Pending</option>
                                <option value="approved">Approved</option>
                                <option value="rejected">rejected</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>


            <div class="mt-4">
                <button type="submit" class="btn btn-primary w-md">
                    Update
                </button>
            </div>

        </form>
    </div> --}}
@endsection
