<x-app-layout>

    <!-- hero section start  -->
    <section id="hero" class=" position-relative overflow-hidden">
        <div class="pattern-overlay pattern-right position-absolute">
            <img src="{{ asset('assets/images/hero-pattern-right.png') }}" alt="pattern">
        </div>
        <div class="pattern-overlay pattern-left position-absolute">
            <img src="{{ asset('assets/images/hero-pattern-left.png') }}" alt="pattern">
        </div>
        <div class="hero-content container text-center">
            <div class="row">
                <div class="detail mb-4">
                    <h1 class="">Find your <span class="text-primary"> rental car </span> </h1>
                    <p class="hero-paragraph">We have many best rental car collections.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- search section start  -->
    {{-- <section id="search">
        <div class="container search-block p-5">

            <form class="row">
                <div class="col-12 col-md-6 col-lg-3 mt-4 mt-lg-0">
                    <label for="vehicle" class="label-style text-capitalize form-label">Vehicle type</label>
                    <div class="input-group date ">
                        <!-- <input type="text" class="form-control p-3 " id="vehicle" placeholder="Select Car Group" /> -->
                        <select class="form-select form-control p-3" id="vehicle" aria-label="Default select example"
                            style="background-image: none;">
                            <option selected>Select Vehicle Type</option>
                            <option value="1">BMW x3</option>
                            <option value="2">BMW M2</option>
                            <option value="3">Ford explorer</option>
                            <option value="4">Ferrari</option>
                            <option value="5">Mercedes-Benz</option>
                            <option value="6">Sports car</option>
                            <option value="7">Tesla</option>
                        </select>
                        <span class="search-icon-position position-absolute p-3 ">
                            <iconify-icon class="search-icons" icon="solar:bus-outline"></iconify-icon>
                        </span>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-3 mt-4 mt-lg-0">
                    <label for="location" class="label-style text-capitalize form-label">Price</label>
                    <div class="input-group date">
                        <input type="text" class="form-control p-3 position-relative" id="location"
                            placeholder="Airport or anywhere" />
                        <span class="search-icon-position position-absolute p-3 ">
                            <iconify-icon class="search-icons" icon="solar:map-arrow-square-outline"></iconify-icon>
                        </span>


                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-3 mt-4 mt-lg-0">
                    <label for="pick-up-date" class="label-style text-capitalize form-label">Fuel type</label>
                    <div class="input-group date" id="datepicker1">
                        <input type="text" class="form-control p-3" id="pick-up-date" />

                        <span class="input-group-append">
                            <span class="search-icon-position position-absolute p-3">
                                <iconify-icon class="search-icons" icon="solar:calendar-broken"></iconify-icon>
                            </span>
                        </span>

                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-3 mt-4 mt-lg-0">
                    <label for="return-date" class="label-style text-capitalize form-label">Capacity</label>
                    <div class="input-group date" id="datepicker2">
                        <input type="text" class="form-control p-3" id="return-date" />

                        <span class="input-group-append">
                            <span class="search-icon-position position-absolute p-3">
                                <iconify-icon class="search-icons" icon="solar:calendar-broken"></iconify-icon>
                            </span>
                        </span>

                    </div>
                </div>
            </form>

            <div class="d-grid gap-2 mt-4">
                <button class="btn btn-primary " type="button">Find your car</button>
            </div>
        </div>

    </section> --}}

    <section id="search">
        <div class="container search-block p-5">
            <form class="row" method="GET" action="{{ route('search') }}">
                <div class="col-12 mt-4 mt-lg-0">
                    <label for="vehicle" class="label-style text-capitalize form-label">All Available Vehicle </label>
                    <div class="input-group date">
                        <select class="form-select form-control p-3" aria-label="Default select example" name="name">
                            <option selected>Select Vehicle Type</option>
                            @foreach ($cars as $role)
                                <option value="{{ $role->name }}">
                                    {{ $role->name }}
                                </option>
                            @endforeach
                        </select>
                        <span class="search-icon-position position-absolute p-3">
                            <iconify-icon class="search-icons" icon="solar:bus-outline"></iconify-icon>
                        </span>
                    </div>
                </div>

                <div class="d-grid gap-2 mt-4">
                    <button class="btn btn-primary" type="submit">Find your car</button>
                </div>
            </form>
        </div>
    </section>


    <!-- process section start  -->
    <section id="process">
        <div class=" process-content container">
            <h2 class=" text-center my-5 pb-5">Our renting <span class="text-primary"> process </span> </h2>
            <hr class="progress-line">
            <div class="row process-block">
                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Choose a vehicle </h5>
                    <p>Sed euismod mauris corper libero.</p>
                </div>

                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Pick location & date </h5>
                    <p>Nisi maecenas fermentum neque.</p>
                </div>

                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Book your car </h5>
                    <p>Mauris corper accumsan urna sed.</p>
                </div>

                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Finish process </h5>
                    <p>Orci duis ut lectus metus nam sette.</p>
                </div>

            </div>


        </div>
    </section>

    <!-- rental section start  -->
    <!-- rental section start  -->
    <section id="cars" class="my-5 py-5">
        <div class="container">
            <div class="row">
                @foreach ($cars as $car)
                    <div class="col-md-4 my-4">
                        <div class="card">
                            <a href="{{ route('single-car', $car->id) }}">
                                <img src="{{ asset($car->image) }}" height="200px" alt="{{ $car->name }}" class="card-img-top">
                            </a>
                            <div class="card-body p-4">
                                <a href="{{ route('single-car', $car->id) }}">
                                    <h4 class="card-title">{{ $car->name }}</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        {{-- <li class="rental-list">
                                        Sports
                                    </li> --}}
                                        <li class="rental-list display-small"> {{ Str::ucfirst($car->fuel_type) }}</li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h4 class="pt-2">$ {{ $car->price }}<span class="rental-price">/day</span>
                                    </h4>
                                    <a href="{{ route('single-car', $car->id) }}" class="btn btn-primary">Book now
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <nav aria-label="Page navigation" class="d-flex justify-content-center mt-5">
                <ul class="pagination">
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Previous">
                            <iconify-icon icon="solar:arrow-left-linear" class="pagination-arrow"></iconify-icon>
                        </a>
                    </li>
                    <li class="page-item active" aria-current="page"><a class="page-link" href="#">1</a>
                    </li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                    <li class="page-item"><a class="page-link" href="#">4</a></li>
                    <li class="page-item"><a class="page-link" href="#">5</a></li>
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Next">
                            <iconify-icon icon="solar:arrow-right-linear" class="pagination-arrow"></iconify-icon>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </section>

    {{-- <section id="rental" class="position-relative">
        <div class="container my-5 py-5">
            <h2 class=" text-center my-5">cars for <span class="text-primary"> rental </span> </h2>

            <div class="swiper-button-next rental-swiper-next  rental-arrow position-absolute"></div>
            <div class="swiper-button-prev rental-swiper-prev rental-arrow position-absolute"></div>

            <div class="swiper rental-swiper mb-5">
                <div class="swiper-wrapper">

                    <div class="swiper-slide">
                        <div class="card">
                            <a href="car-single.html"><img src="{{ asset('assets/images/car1.png') }}" class="card-img-top" alt="..."></a>
                            <div class="card-body p-4">
                                <a href="car-single.html">
                                    <h4 class="card-title">BMW x3</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        <li class="rental-list">
                                            Sports
                                        </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> Auto</li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> 4 Passengers </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list display-small"> Diesel </li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h3 class="pt-2">$369 <span class="rental-price">/day</span></h3>
                                    <a href="{{route('car')}}" class="btn btn-primary">rent now </a>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="card">
                            <a href="car-single.html"><img src="{{ asset('assets/images/car2.png') }}" class="card-img-top" alt="..."></a>
                            <div class="card-body p-4">
                                <a href="car-single.html">
                                    <h4 class="card-title">BMW M2</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        <li class="rental-list">
                                            Sports
                                        </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> Auto</li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> 4 Passengers </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list display-small"> Diesel </li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h3 class="pt-2">$369 <span class="rental-price">/day</span></h3>
                                    <a href="car-single.html" class="btn btn-primary">rent now </a>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="card">
                            <a href="car-single.html"><img src="{{ asset('assets/images/car3.png') }}" class="card-img-top" alt="..."></a>
                            <div class="card-body p-4">
                                <a href="car-single.html">
                                    <h4 class="card-title">Ford explorer</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        <li class="rental-list">
                                            Sports
                                        </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> Auto</li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> 4 Passengers </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list display-small"> Diesel </li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h3 class="pt-2">$369 <span class="rental-price">/day</span></h3>
                                    <a href="car-single.html" class="btn btn-primary">rent now </a>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="card">
                            <a href="car-single.html"><img src="{{ asset('assets/images/car1.png') }}" class="card-img-top" alt="..."></a>
                            <div class="card-body p-4">
                                <a href="car-single.html">
                                    <h4 class="card-title">BMW x3</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        <li class="rental-list">
                                            Sports
                                        </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> Auto</li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> 4 Passengers </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list display-small"> Diesel </li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h3 class="pt-2">$369 <span class="rental-price">/day</span></h3>
                                    <a href="car-single.html" class="btn btn-primary">rent now </a>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="card">
                            <a href="car-single.html"><img src="{{ asset('assets/images/car2.png') }}" class="card-img-top" alt="..."></a>
                            <div class="card-body p-4">
                                <a href="car-single.html">
                                    <h4 class="card-title">BMW M2</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        <li class="rental-list">
                                            Sports
                                        </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> Auto</li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> 4 Passengers </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list display-small"> Diesel </li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h3 class="pt-2">$369 <span class="rental-price">/day</span></h3>
                                    <a href="car-single.html" class="btn btn-primary">rent now </a>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="card">
                            <a href="car-single.html"><img src="{{ asset('assets/images/car3.png') }}" class="card-img-top" alt="..."></a>
                            <div class="card-body p-4">
                                <a href="car-single.html">
                                    <h4 class="card-title">Ford explorer</h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        <li class="rental-list">
                                            Sports
                                        </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> Auto</li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list"> 4 Passengers </li>
                                        <li class="rental-list"> <img src="{{ asset('assets/images/dot.png') }}" class="px-3" alt="image">
                                        </li>
                                        <li class="rental-list display-small"> Diesel </li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h3 class="pt-2">$369 <span class="rental-price">/day</span></h3>
                                    <a href="car-single.html" class="btn btn-primary">rent now </a>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </div>



    </section> --}}

    <!-- services section start  -->
    <section id="services">

        <div class="container  py-5 my-5">
            <div class="row py-5 ">
                <div class=" pb-5  col-10 col-sm-8 col-lg-6">
                    <h2 class="">See <span class="text-primary">best services</span> for your solution </h2>
                </div>
                <div class=" pb-5  col-lg-6">
                    <p class="pt-4">Vitae aliquam vestibulum elit adipiscing massa diam in dignissim. Risus tellus
                        libero elementum aliquam etiam. Lectus adipiscing est auctor mi quisque nunc non vive adipiscing
                        massa diam in digniss imrra est. </p>
                </div>
            </div>

        </div>

    </section>

    <section id="service-2">
        <div class=" services-sub container mb-5 pb-5">
            <div class="row">
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:shield-check-outline"></iconify-icon>
                        <h5>Secured Payment</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:bookmark-opened-outline"></iconify-icon>
                        <h5>any class vehicle</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:user-circle-outline"></iconify-icon>
                        <h5>Car sharing options</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:call-chat-outline"></iconify-icon>
                        <h5>Help center & Support</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>

            </div>
        </div>

    </section>

    <!-- faq section start  -->
    <section id="faq">

        <div class="container my-5 py-5 ">
            <h2 class=" text-center my-5">We’ve got <span class="text-primary"> answers</span> </h2>


            <div class="accordion col-md-8 offset-md-2" id="accordionPanelsStayOpenExample">

                <div class="accordion-item mt-3">
                    <h5 class="accordion-header" id="panelsStayOpen-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true"
                            aria-controls="panelsStayOpen-collapseOne">
                            Why to believe with GoCar Car rental service ?
                        </button>
                    </h5>
                    <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse show">
                        <div class="accordion-body">
                            <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in aliquet tincidunt
                                nam lectus nec. Placerat interdum auctor facilisi massa laoreet hendrerit posuere a.
                                Tristique ultricies consectetu at.</p>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="accordion-item mt-3">
                    <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false"
                            aria-controls="panelsStayOpen-collapseTwo">
                            How to know which renting price price is best?
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingTwo">
                        <div class="accordion-body">
                            <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in aliquet tincidunt
                                nam lectus
                                nec. Placerat interdum auctor facilisi massa laoreet hendrerit posuere a. Tristique
                                ultricies consectetu
                                at.</p>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="accordion-item mt-3">
                    <h2 class="accordion-header" id="panelsStayOpen-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseThree" aria-expanded="false"
                            aria-controls="panelsStayOpen-collapseThree">
                            What are the special features of gocar?
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingThree">
                        <div class="accordion-body">
                            <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in aliquet tincidunt
                                nam lectus
                                nec. Placerat interdum auctor facilisi massa laoreet hendrerit posuere a. Tristique
                                ultricies consectetu
                                at.</p>
                        </div>
                    </div>
                </div>
                <hr>




            </div>

        </div>
    </section>



    <!-- call-to-action section start  -->
    <section id="action" class="position-relative">

        <div class="pattern-overlay pattern-right position-absolute">
            <img src="{{ asset('assets/images/call-to-action-pattern.png') }}" alt="pattern">
        </div>

        <div class="container  py-5 my-5">
            <div class="row py-5 ">
                <div class=" col-10 col-sm-8 col-lg-6">
                    <h2 class="">Let’s begin with <span class="text-primary">GoCar rental.</span> </h2>
                </div>
                <div class=" col-lg-6">
                    <p>Neque, vestibulum sed varius magna et at. Eu, adipiscing morbi augue justo. Nibh laoreet volutpat
                        quis velit. Blandit aliquam donec sed morbi congue eget lorem viverra porta id lobortis.</p>
                    <a href="{{ route('contact') }}" class="btn btn-primary mt-2">Contact us </a>
                </div>
            </div>

        </div>

    </section>



</x-app-layout>
