<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\Booking;
use Illuminate\Http\Request;
use App\Models\Car;
use App\Models\Feedback;

class PageController extends Controller
{
    public function cars()
    {
        $cars = Car::all();
        // dd($cars);
        return view('my.authuser.car',  ['cars' => $cars]);
    }

    public function car($id)
    {
        $car = Car::findOrFail($id);
        return view('my.authuser.car-single', ['car' => $car]);
    }


    public function contact()
    {
        return view('my.authuser.contact');
    }

    public function faq()
    {
        $faqs = Feedback::whereNull('rating')
            ->where('display', 1)
            ->get();
        // dd($faqs);
        return view('my.authuser.faq', ['faqs' => $faqs]);
    }

    public function about()
    {
        return view('my.authuser.about');
    }


    public function service()
    {
        return view('my.authuser.service');
    }

    public function team()
    {
        return view('my.authuser.team');
    }

    public function review()
    {
        $feedbacks = Feedback::whereNotNull('rating')
            ->where('display', 1)
            ->get();
        // dd($feedbacks);
        return view('my.authuser.review', ['feedbacks' => $feedbacks]);
    }

    public function dashboard()
    {
        $cars = Car::all();
        return view('dashboard', ['cars' => $cars]);
    }

    public function status($id)
    {
        $bookings = Booking::where('user_id', $id)->get();
        // dd($booking->name);
        return view('my.authuser.booking-status', ['bookings' => $bookings]);
    }
}
