<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\Feedback;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FeedbackController extends Controller
{
    public function create()
    {
        return view('my.authuser.booking' );
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        $request->validate([
            'subject' => 'required|string|max:255',
            // 'message' => 'required|string',
        ]);


        $feedback = new Feedback();
        $feedback->user_id = Auth::id();
        $feedback->subject = $request->input('subject');

        $page = $request->query('page');
        if ($page === 'feedback') {
            // Handle FAQ form submission

            $request->validate([
                'subject' => 'required|string|max:255',
                'rating' =>  'required|integer|between:1,5',
                // 'message' => 'required|string',
            ]);
            $feedback->rating = $request->input('rating');

        }
        //  elseif ($page === 'faq') {
        //     // Handle Feedback form submission
        // }
        $feedback->save();






















        // Create a new feedback entry
    //    $saved = Feedback::create([
    //         'user_id' => Auth::id(),
    //         'subject' => $request->input('question'),
    //         'rating' => $request->input('rating'),
    //         // 'comment' => $request->input('question'),

    //     ]);

        // Redirect back with a success message
        if(!$feedback){
            return redirect()->back()->with('success', 'Feedback submitted successfully!');
        }

        return redirect()->back()->with('error', 'SomeThing bad Happened!');


    }


}
