<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // $users = User::with('roles')->get();
        $users = User::where('role' , 'user')->get();
        // dd($users);
        return view('my.admin.user.index' , ['users' => $users] );
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort(404);
        // $roles = Role::all();
        // return view('my.admin.user.create' , ['roles' => $roles]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        abort(404);

    }

    /**
     * Display the specified resource.
     */
    public function show(User $user)
    {
        abort(404);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(User $user)
    {
        abort('404');
    //     $roles = Role::all();
    //     $userRoles =  $user->roles->pluck('id')->toArray();
    //     // dd($userRoles);
    //    return view('my.admin.user.edit' , [
    //     'user' => $user,
    //     'roles' => $roles,
    //     'userRoles' => $userRoles
    // ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request,User $user)
    {
        // dd($request->all());
        $request->validate([
            'name' => 'required',
            // 'password' => 'required|string|min:8|confirmed',
            'email' => 'required|unique:users,email,' . $user->id,
        ]);

        $user->name = $request->name;
        $user->email = $request->email;
        $user->syncRoles($request->roles);
        $user->update();
        return redirect('admin/user')->with('success', 'User data has been updated');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(User $user)
    {
         // Check if the user has an associated image
    if ($user->image) {
        // Get the full path of the image
        $imagePath = public_path($user->image);

        // Check if the image file exists
        if (file_exists($imagePath)) {
            // Delete the image file
            unlink($imagePath);
        }
    }

    // Delete the user record from the database
    $user->delete();

    // Redirect back with a success message
    return redirect()->back()->with('success', 'User deleted successfully!');
    }
}
