<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Message;

class MessageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

        // $messages = Message::all();
        $messages = Message::orderBy('created_at', 'desc')->get();
        // dd($messages);
        return view('my.admin.message.index', ['messages' => $messages]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    // public function store(Request $request)
    // {
    //     // dd($request->all());
    //     // Validate the request
    //     $request->validate([
    //         'subject' => 'required|string|max:255',
    //         'message' => 'required|string',
    //     ]);

    //     // Create a new message entry
    //     message::create([
    //         'user_id' => Auth::id(),
    //         'subject' => $request->input('subject'),
    //         'message' => $request->input('message'),
    //     ]);

    //     // Redirect back with a success message
    //     return redirect()->back()->with('success', 'message submitted successfully!');
    // }

    /**
     * Display the specified resource.
     */
    public function show( $id)
    {
        $message = message::findOrFail($id);
        $message->is_read = true;
        $message->save();
        return view('my.admin.message.edit', ['message' => $message]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(message $message)
    {
        //
        abort(404);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, message $message)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(message $message)
    {
        //
    }
}
