<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Car;
use Illuminate\Http\Request;

class CarController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $cars = Car::paginate(5);
        // dd($cars);
        return view('my.admin.car.index', ['cars' => $cars]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('my.admin.car.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'fuel_type' => 'required|string',
            'price' => 'required|numeric',
            'capacity' => 'required|numeric',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'status' => 'required',
            // 'status' => 'required|in:available,rented,maintenance',
        ]);
        // dd($request->all());

        $car = new Car($request->all());

        if ($request->hasFile('image')) {
            // $imagePath = $request->file('image')->store('cars', 'public');
            // $car->image = $imagePath;

            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('images'), $imageName);
            $car->image = 'images/' . $imageName;
        }

        $car->save();

        // return redirect()->route('cars.index')->with('success', 'Car added successfully!');
        return redirect()->back()->with('success', 'Car added successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Car $car)
    {
        return view('my.admin.car.edit', ['car' => $car]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Car $car)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'fuel_type' => 'required|string',
            'price' => 'required|numeric',
            'capacity' => 'required|numeric',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'status' => 'required',
        ]);

        // Update car attributes from the request
        $car->fill($request->all());

        if ($request->hasFile('image')) {
            // Check if the car already has an image
            if ($car->image) {
                // Delete the old image from the public/images directory
                $oldImagePath = public_path($car->image);
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath);
                }
            }


            // Store the new image
            $imageName = time() . '.' . $request->image->extension();
            $request->image->move(public_path('images'), $imageName);
            $car->image = 'images/' . $imageName;
        }

        // Save the updated car
        $car->save();

        // Redirect back with success message
        return redirect()->back()->with('success', 'Car updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Car $car)
    {
        if ($car->image) {
            // Get the full path of the image
            $imagePath = public_path($car->image);

            // Check if the image file exists
            if (file_exists($imagePath)) {
                // Delete the image file
                unlink($imagePath);
            }
        }

        // Delete the car record from the database
        $car->delete();

        // Redirect back with a success message
        return redirect()->back()->with('success', 'Car deleted successfully!');

    }
}
